<?php 
/**
 * The template for displaying index page
 *
 * @version    0.1.25
 * @package    shop-entertainment
 * @author     Zidithemes
 * @copyright  Copyright (C) 2021 zidithemes.com All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * 
 */
?>

<?php get_header(); ?>

	


<?php

$shop_entertainment_index_cn = esc_html(get_theme_mod('shop_entertainment_index_class_name_settings'));
$shop_entertainment_feature_change_style = esc_html(get_theme_mod('shop_entertainment_feature_change_style_settings'));

$is_elementor_theme_exist = function_exists( 'elementor_theme_do_location' );


if ( ! $is_elementor_theme_exist || ! elementor_theme_do_location( 'index' ) ) {

?>

<div id="content" class="page-content">

	<div class="flowid  
			<?php if ( !empty( $shop_entertainment_index_cn )): ?>
					<?php echo esc_attr($shop_entertainment_index_cn); ?>
				<?php else: ?> 
					<?php echo 'shop-entertainment-index'; ?>
			<?php endif; ?> ">


		<!-- BEGIN SHOW -->
        <div class="mg-auto wid-90 mobwid-90">
        	<div class="
                        <?php if ( !empty( $shop_entertainment_feature_change_style )): ?>
                            <?php echo esc_attr($shop_entertainment_feature_change_style); ?>
                            <?php else: ?> 
                            <?php echo 'shop-entertainment-feature'; ?>
                        <?php endif; ?>
                        shop-entertainment-no-feature">
				<div class="shop-entertainment-show shop-entertainment-show-mob-no dsply-fl fl-wrap jc-sp-btw">
					<div class="left-side wid-33 mobwid-100">
					<?php $shop_entertainment_index_blog_posts = new WP_Query( array( 'posts_per_page' => 1, 'paged' => $paged ) );

		                        if ( $shop_entertainment_index_blog_posts->have_posts() ) : while ( $shop_entertainment_index_blog_posts->have_posts() ) : $shop_entertainment_index_blog_posts->the_post(); ?>

		                        <div class="wid-100 mobwid-100 shop-entertainment-show-items relative">
			                        	<?php if ( has_post_thumbnail()) : ?>
						                <a href="<?php the_permalink(); ?>"  >
						                    <?php the_post_thumbnail(); ?>
						                </a>
						                <?php else: ?>
						                	<a href="<?php the_permalink(); ?>"  >
							                    <div class="user-no-img-items">
							                        <div class="user-no-img-items-inner text-center">
							                            <div class=""><?php esc_html_e( 'No Image', 'shop-entertainment' ); ?></div>
							                        </div>
							                    </div>
						                	</a>
						                <?php endif; ?>
							            <div class="shop-entertainment-show-items-content text-center">
							                <div class="date"><?php the_time(get_option('date_format')); ?></div>
							                <h5>
							                	<a href="<?php the_permalink(); ?>"  >
							                        <?php the_title(); ?>
							                    </a>
							                </h5>
							                <p>
							                	<a class="excerpt" href="<?php the_permalink(); ?>">
							                		<?php the_excerpt(__('Read more &raquo;', 'shop-entertainment')); ?>
							                	</a>
							                </p>
							            </div>
							        
		                        </div>

						<?php endwhile; else : ?>
								<h2><?php esc_html_e('No posts Found!', 'shop-entertainment'); ?></h2>

								<?php wp_reset_postdata(); ?>
						<?php endif; ?>	

					</div>
					<div class="middle-side wid-33 dsply-fl fl-wrap jc-sp-btw mobwid-100">
						<?php $shop_entertainment_index_middle_side_blog_posts = new WP_Query( array( 'posts_per_page' => 3, 'paged' => $paged ) );

		                        if ( $shop_entertainment_index_middle_side_blog_posts->have_posts() ) : while ( $shop_entertainment_index_middle_side_blog_posts->have_posts() ) : $shop_entertainment_index_middle_side_blog_posts->the_post(); ?>

		                        <div class="wid-49 dsply-fl mobwid-100 shop-entertainment-show-items relative">
		                        		<div class="wid-100 relative shop-entertainment-show-items-link">
				                        	<?php if ( has_post_thumbnail()) : ?>
							                <a href="<?php the_permalink(); ?>"  >
							                    <?php the_post_thumbnail(); ?>
							                </a>
							                <?php else: ?>
							                	<a href="<?php the_permalink(); ?>"  >
								                    <div class="user-no-img-items">
								                        <div class="user-no-img-items-inner text-center">
								                            <div class=""><?php esc_html_e( 'No Image', 'shop-entertainment' ); ?></div>
								                        </div>
								                    </div>
							                	</a>
							                <?php endif; ?>
						            	</div>
							            <div class="wid-100 jc-center ai-center dsply-fl shop-entertainment-show-items-content text-center">
							            	<div class="shop-entertainment-show-items-content-inner">
								                <div class="date"><?php the_time(get_option('date_format')); ?></div>
								                <h5>
								                	<a href="<?php the_permalink(); ?>"  >
								                        <?php the_title(); ?>
								                    </a>
								                </h5>
								                <p class="para">
								                	<a class="excerpt" href="<?php the_permalink(); ?>">
								                		<?php the_excerpt(__('Read more &raquo;', 'shop-entertainment')); ?>
								                	</a>
								                </p>
							            	</div>
							            </div>
							        
		                        </div>

						<?php endwhile; else : ?>
								<h2><?php esc_html_e('No posts Found!', 'shop-entertainment'); ?></h2>

								<?php wp_reset_postdata(); ?>
						<?php endif; ?>	
					</div>

					<div class="right-side wid-33 mobwid-100">
					<?php $shop_entertainment_index_right_blog_posts = new WP_Query( array( 'posts_per_page' => 4, 'paged' => $paged ) );

		                        if ( $shop_entertainment_index_right_blog_posts->have_posts() ) : while ( $shop_entertainment_index_right_blog_posts->have_posts() ) : $shop_entertainment_index_right_blog_posts->the_post(); ?>

		                        <div class="wid-100 mobwid-100 shop-entertainment-show-items relative">
			                        	<?php if ( has_post_thumbnail()) : ?>
						                <a href="<?php the_permalink(); ?>"  >
						                    <?php the_post_thumbnail(); ?>
						                </a>
						                <?php else: ?>
						                	<a href="<?php the_permalink(); ?>"  >
							                    <div class="user-no-img-items">
							                        <div class="user-no-img-items-inner text-center">
							                            <div class=""><?php esc_html_e( 'No Image', 'shop-entertainment' ); ?></div>
							                        </div>
							                    </div>
						                	</a>
						                <?php endif; ?>
							            <div class="shop-entertainment-show-items-content text-center">
							                <div class="date"><?php the_time(get_option('date_format')); ?></div>
							                <h5>
							                	<a href="<?php the_permalink(); ?>"  >
							                        <?php the_title(); ?>
							                    </a>
							                </h5>
							                <p>
							                	<a class="excerpt" href="<?php the_permalink(); ?>">
							                		<?php the_excerpt(__('Read more &raquo;', 'shop-entertainment')); ?>
							                	</a>
							                </p>
							            </div>
							        
		                        </div>

						<?php endwhile; else : ?>
								<h2><?php esc_html_e('No posts Found!', 'shop-entertainment'); ?></h2>

								<?php wp_reset_postdata(); ?>
						<?php endif; ?>	

					</div>	

				</div>
			</div>
		</div>
		<!-- END SHOW -->

		
            <!-- BEGIN INDEX IMAGE GALLERY -->

            <div class="mg-auto wid-90 mobwid-90">
                
                <div class="inner dsply-fl fl-wrap">
                	<div class="shop-entertainment-no-img-gallery wid-100">
	                    <div class="shop-entertainment-img-gallery dsply-fl fl-wrap">

	                        <div class="full-width  dsply-fl fl-wrap jc-sp-btw wid-100 mobwid-100">
	                        <?php $shop_entertainment_img_gallery_blog_posts = new WP_Query( array( 'posts_per_page' => 9, 'paged' => $paged ) );

	                                    if ( $shop_entertainment_img_gallery_blog_posts->have_posts() ) : while ( $shop_entertainment_img_gallery_blog_posts->have_posts() ) : $shop_entertainment_img_gallery_blog_posts->the_post(); ?>

	                                    <div class="wid-100 mobwid-100 shop-entertainment-img-gallery-items relative">
	                                            <?php if ( has_post_thumbnail()) : ?>
	                                            <a href="<?php the_permalink(); ?>"  >
	                                                <?php the_post_thumbnail(); ?>
	                                            </a>
	                                            <?php else: ?>
	                                                <a href="<?php the_permalink(); ?>"  >
	                                                    <div class="user-no-img-items">
	                                                        <div class="user-no-img-items-inner text-center">
	                                                            <div class=""><?php esc_html_e( 'No Image', 'shop-entertainment' ); ?></div>
	                                                        </div>
	                                                    </div>
	                                                </a>
	                                            <?php endif; ?>
	                                            <div class="shop-entertainment-img-gallery-items-content text-left">
	                                                <h5><a href="<?php the_permalink(); ?>"  >
	                                                        <?php the_title(); ?>
	                                                    </a>
	                                                </h5>
	                                                <div class="date"><?php the_time(get_option('date_format')); ?></div>
	                                                <p>
	                                                	<a class="excerpt" href="<?php the_permalink(); ?>">
	                                                		<?php the_excerpt(__('Read more &raquo;', 'shop-entertainment')); ?>
	                                                	</a>
	                                                </p>
	                                            </div>
	                                        
	                                    </div>

	                            <?php endwhile; else : ?>
		                            <h2><?php esc_html_e('No posts Found!', 'shop-entertainment'); ?></h2>

		                            <?php wp_reset_postdata(); ?>
	                            <?php endif; ?> 

	                        </div>
	                    </div>
                	</div>
                </div>
            </div>
                    <!-- END INDEX IMAGE GALLERY -->


	    <div class="mg-auto wid-90 mobwid-90">
	        
	        <div class="inner dsply-fl fl-wrap">
	            
	            <div class="wid-70 mobwid-100 blog-2-col-inner">
	            	

	            	
                    <!-- BEGIN SHOP ENTERTAINMENT DIFF-->

                    <div class="shop-entertainment-no-diff">
                    	<div class="shop-entertainment-diff dsply-fl fl-wrap jc-sp-btw">

	                        <div class="left-side wid-49 mobwid-100">
	                        <?php $shop_entertainment_diff_blog_posts = new WP_Query( array( 'posts_per_page' => 5, 'paged' => $paged ) );

	                                    if ( $shop_entertainment_diff_blog_posts->have_posts() ) : while ( $shop_entertainment_diff_blog_posts->have_posts() ) : $shop_entertainment_diff_blog_posts->the_post(); ?>

	                                    <div class="wid-100 mobwid-100 shop-entertainment-diff-items relative">
	                                            <?php if ( has_post_thumbnail()) : ?>
	                                            <a href="<?php the_permalink(); ?>"  >
	                                                <?php the_post_thumbnail(); ?>
	                                            </a>
	                                            <?php else: ?>
	                                                <a href="<?php the_permalink(); ?>"  >
	                                                    <div class="user-no-img-items">
	                                                        <div class="user-no-img-items-inner text-center">
	                                                            <div class=""><?php esc_html_e( 'No Image', 'shop-entertainment' ); ?></div>
	                                                        </div>
	                                                    </div>
	                                                </a>
	                                            <?php endif; ?>
	                                            <div class="shop-entertainment-diff-items-content text-left">
	                                                <h5><a href="<?php the_permalink(); ?>"  >
	                                                        <?php the_title(); ?>
	                                                    </a>
	                                                </h5>
	                                                <div class="date"><?php the_time(get_option('date_format')); ?></div>
	                                                <p>
	                                                	<a class="excerpt" href="<?php the_permalink(); ?>">
	                                                		<?php the_excerpt(__('Read more &raquo;', 'shop-entertainment')); ?>
	                                                	</a>
	                                                </p>
	                                            </div>
	                                        
	                                    </div>

	                            <?php endwhile; else : ?>
		                            <h2><?php esc_html_e('No posts Found!', 'shop-entertainment'); ?></h2>

		                            <?php wp_reset_postdata(); ?>
	                            <?php endif; ?> 

	                        </div>
	                        <div class="right-side wid-49 mobwid-100">
	                            <?php $shop_entertainment_right_diff_side_blog_posts = new WP_Query( array( 'posts_per_page' => 9, 'paged' => $paged ) );

	                                    if ( $shop_entertainment_right_diff_side_blog_posts->have_posts() ) : while ( $shop_entertainment_right_diff_side_blog_posts->have_posts() ) : $shop_entertainment_right_diff_side_blog_posts->the_post(); ?>

	                                    <div class="wid-100  mobwid-100 shop-entertainment-diff-items relative">
	                                        <div class="shop-entertainment-diff-items-inner dsply-fl jc-sp-btw">
	                                            <div class="wid-34 relative shop-entertainment-diff-items-link">
	                                                <?php if ( has_post_thumbnail()) : ?>
	                                                <a href="<?php the_permalink(); ?>"  >
	                                                    <?php the_post_thumbnail(); ?>
	                                                </a>
	                                                <?php else: ?>
	                                                    <a href="<?php the_permalink(); ?>"  >
	                                                        <div class="user-no-img-items">
	                                                            <div class="user-no-img-items-inner text-center">
	                                                                <div class=""><?php esc_html_e( 'No Image', 'shop-entertainment' ); ?></div>
	                                                            </div>
	                                                        </div>
	                                                    </a>
	                                                <?php endif; ?>
	                                            </div>
	                                            <div class="wid-65 shop-entertainment-diff-items-content text-left">
	                                                <div class="shop-entertainment-diff-items-content-inner">
	                                                    <h5>
	                                                    	<a href="<?php the_permalink(); ?>"  >
	                                                            <?php the_title(); ?>
	                                                        </a>
	                                                    </h5>
	                                                    <div class="date"><?php the_time(get_option('date_format')); ?></div>
	                                                    <p class="para">
	                                                        <a class="excerpt" href="<?php the_permalink(); ?>">
	                                                            <?php the_excerpt(__('Read more &raquo;', 'shop-entertainment')); ?>
	                                                        </a>
	                                                    </p>
	                                                </div>
	                                            </div>
	                                        </div>
	                                    </div>

	                            <?php endwhile; else : ?>
	                                <h2><?php esc_html_e('No posts Found!', 'shop-entertainment'); ?></h2>

	                            	<?php wp_reset_postdata(); ?>
	                            <?php endif; ?> 
	                        </div>
                    	</div>
                    </div>


                    <!-- END SHOP ENTERTAINMENT DIFF -->
	            	

	            	
	                <div class="mg-tp dsply-fl fl-wrap jc-sp-btw">
	                <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>	

	                	<?php get_template_part('content', get_post_format());  ?>
	                	 
	                	
	                    <?php endwhile; else : ?>
							<h2><?php esc_html_e('No posts Found!', 'shop-entertainment'); ?></h2>
	                    <?php endif; ?>

	                </div>
	                <ul class="pagination flowid">
					   <?php the_posts_pagination(); ?>
					</ul>
	            </div>
	            <?php get_sidebar(); ?>

	        </div>

	    </div>
	</div>
</div>

<?php } ?>


<?php get_footer(); ?>