<?php
/**
 * Promotion Headline Options
 *
 * @package ScapeShot
 */

/**
 * Add promotion headline options to theme options
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function scapeshot_promo_head_options( $wp_customize ) {
	$wp_customize->add_section( 'scapeshot_promotion_headline', array(
			'title' => esc_html__( 'Promotion Headline', 'scapeshot-light' ),
			'panel' => 'scapeshot_theme_options',
		)
	);

	scapeshot_register_option( $wp_customize, array(
			'name'              => 'scapeshot_promo_head_visibility',
			'default'           => 'disabled',
			'sanitize_callback' => 'scapeshot_sanitize_select',
			'choices'           => scapeshot_section_visibility_options(),
			'label'             => esc_html__( 'Enable on', 'scapeshot-light' ),
			'section'           => 'scapeshot_promotion_headline',
			'type'              => 'select',
		)
	);

	scapeshot_register_option( $wp_customize, array(
			'name'              => 'scapeshot_promotion_headline',
			'default'           => '0',
			'sanitize_callback' => 'scapeshot_sanitize_post',
			'active_callback'   => 'scapeshot_is_promotion_headline_active',
			'label'             => esc_html__( 'Page', 'scapeshot-light' ),
			'section'           => 'scapeshot_promotion_headline',
			'type'              => 'dropdown-pages',
		)
	);
	scapeshot_register_option( $wp_customize, array(
			'name'              => 'scapeshot_promotion_headline_section_tagline',
			'sanitize_callback' => 'sanitize_text_field',
			'active_callback'   => 'scapeshot_is_promotion_headline_active',
			'label'             => esc_html__( 'Section Tagline', 'scapeshot-light' ),
			'description'       => esc_html__( 'Displays above title', 'scapeshot-light' ),
			'section'           => 'scapeshot_promotion_headline',
			'type'              => 'text',
		)
	);
}
add_action( 'customize_register', 'scapeshot_promo_head_options', 99 );

/** Active Callback Functions **/
if ( ! function_exists( 'scapeshot_is_promotion_headline_active' ) ) :
	/**
	* Return true if promotion headline is active
	*
	* @since ScapeShot Pro 1.0
	*/
	function scapeshot_is_promotion_headline_active( $control ) {
		$enable = $control->manager->get_setting( 'scapeshot_promo_head_visibility' )->value();

		return scapeshot_check_section( $enable );
	}
endif;