<?php
/**
 * The template part for displaying slider
 *
 * @package Art Gallery Museum
 * @subpackage art_gallery_museum
 * @since Art Gallery Museum 1.0
 */
?>
<div class="col-lg-4 col-md-4">
  <article id="post-<?php the_ID(); ?>" <?php post_class('inner-service'); ?>>
    <div class="services-box mb-4">    
      <?php if(has_post_thumbnail() && get_theme_mod( 'art_gallery_museum_feature_image_hide',true) != '') { ?>
        <div class="service-image">
          <a href="<?php echo esc_url( get_permalink() ); ?>">
            <?php  the_post_thumbnail(); ?>
            <span class="screen-reader-text"><?php the_title(); ?></span>
          </a>
        </div>
      <?php }?>
      <div class="tc-category-section">
      <div class="tc-category">
         <?php the_category(); ?>
      </div>
      <h2 class="py-3"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title(); ?></a></h2>
      <div class="lower-box">
        <?php if(get_the_excerpt()) { ?>
          <p><?php $art_gallery_museum_excerpt = get_the_excerpt(); echo esc_html( art_gallery_museum_string_limit_words( $art_gallery_museum_excerpt, esc_attr(get_theme_mod('art_gallery_museum_post_excerpt_length','20')))); ?><?php echo esc_html( get_theme_mod('art_gallery_museum_button_excerpt_suffix','[...]') ); ?></p>
        <?php }?>
        <?php if ( get_theme_mod('art_gallery_museum_post_button_text','READ MORE') != '' ) {?>
          <div class="read-btn mt-4">
            <a href="<?php echo esc_url( get_permalink() );?>" class="blogbutton-small" ><?php echo esc_html( get_theme_mod('art_gallery_museum_post_button_text',__( 'READ MORE','art-gallery-museum' )) ); ?><span class="screen-reader-text"><?php echo esc_html( get_theme_mod('art_gallery_museum_post_button_text',__( 'READ MORE','art-gallery-museum' )) ); ?></span>
            </a>
          </div>
        <?php }?>
      </div>
     </div>
    </div>
  </article>
</div>