jQuery(function($){
	"use strict";
	jQuery('.main-menu-navigation > ul').superfish({
		delay: 500,
		animation: {opacity:'show',height:'show'},
		speed:'fast'
	});
});

function art_gallery_museum_menu_open() {
	jQuery(".side-menu").addClass('open');
}
function art_gallery_museum_menu_close() {
	jQuery(".side-menu").removeClass('open');
}

function art_gallery_museum_search_show() {
	jQuery(".search-outer").addClass('show');
	jQuery(".search-outer").fadeIn();
}
function art_gallery_museum_search_hide() {
	jQuery(".search-outer").removeClass('show');
	jQuery(".search-outer").fadeOut();
}

(function( $ ) {

	$(window).scroll(function(){
		var sticky = $('.sticky-header'),
		scroll = $(window).scrollTop();

		if (scroll >= 100) sticky.addClass('fixed-header px-lg-3 px-2');
		else sticky.removeClass('fixed-header px-lg-3 px-2');
	});

	// Back to top
	jQuery(document).ready(function () {
    jQuery(window).scroll(function () {
      if (jQuery(this).scrollTop() > 0) {
      	jQuery('.scrollup').fadeIn();
      } else {
        jQuery('.scrollup').fadeOut();
      }
    });
    jQuery('.scrollup').click(function () {
      jQuery("html, body").animate({
        scrollTop: 0
      }, 600);
      return false;
    });
	});

	// Window load function
	window.addEventListener('load', (event) => {
		jQuery(".preloader").delay(2000).fadeOut("slow");
	});

})( jQuery );

( function( window, document ) {
	function art_gallery_museum_keepFocusInMenu() {
		document.addEventListener( 'keydown', function( e ) {
			const art_gallery_museum_nav = document.querySelector( '.side-menu' );

			if ( ! art_gallery_museum_nav || ! art_gallery_museum_nav.classList.contains( 'open' ) ) {
				return;
			}

			const elements = [...art_gallery_museum_nav.querySelectorAll( 'input, a, button' )],
				art_gallery_museum_lastEl = elements[ elements.length - 1 ],
				art_gallery_museum_firstEl = elements[0],
				art_gallery_museum_activeEl = document.activeElement,
				tabKey = e.keyCode === 9,
				shiftKey = e.shiftKey;

			if ( ! shiftKey && tabKey && art_gallery_museum_lastEl === art_gallery_museum_activeEl ) {
				e.preventDefault();
				art_gallery_museum_firstEl.focus();
			}

			if ( shiftKey && tabKey && art_gallery_museum_firstEl === art_gallery_museum_activeEl ) {
				e.preventDefault();
				art_gallery_museum_lastEl.focus();
			}
		} );
	}
	
	function art_gallery_museum_keepfocus_search() {
		document.addEventListener( 'keydown', function( e ) {
			const art_gallery_museum_search = document.querySelector( '.search-outer' );

			if ( ! art_gallery_museum_search || ! art_gallery_museum_search.classList.contains( 'show' ) ) {
				return;
			}

			const elements = [...art_gallery_museum_search.querySelectorAll( 'input, a, button' )],
				art_gallery_museum_lastEl = elements[ elements.length - 1 ],
				art_gallery_museum_firstEl = elements[0],
				art_gallery_museum_activeEl = document.activeElement,
				tabKey = e.keyCode === 9,
				shiftKey = e.shiftKey;

			if ( ! shiftKey && tabKey && art_gallery_museum_lastEl === art_gallery_museum_activeEl ) {
				e.preventDefault();
				art_gallery_museum_firstEl.focus();
			}

			if ( shiftKey && tabKey && art_gallery_museum_firstEl === art_gallery_museum_activeEl ) {
				e.preventDefault();
				art_gallery_museum_lastEl.focus();
			}
		} );
	}

	art_gallery_museum_keepFocusInMenu();

	art_gallery_museum_keepfocus_search();
} )( window, document );
