<?php
//about theme info
add_action( 'admin_menu', 'art_gallery_museum_gettingstarted' );
function art_gallery_museum_gettingstarted() {    	
	add_theme_page( esc_html__('Get Started', 'art-gallery-museum'), esc_html__('Get Started', 'art-gallery-museum'), 'edit_theme_options', 'art_gallery_museum_guide', 'art_gallery_museum_mostrar_guide');   
}

// Add a Custom CSS file to WP Admin Area
function art_gallery_museum_admin_theme_style() {
   wp_enqueue_style('art-gallery-museum-custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/dashboard/getstart.css');
   wp_enqueue_script('tabs', esc_url(get_template_directory_uri()) . '/inc/dashboard/js/tab.js');
}
add_action('admin_enqueue_scripts', 'art_gallery_museum_admin_theme_style');

//guidline for about theme
function art_gallery_museum_mostrar_guide() { 
	//custom function about theme customizer
	$return = add_query_arg( array()) ;
	$theme = wp_get_theme( 'art-gallery-museum' );
?>

<div class="wrapper-info">  
    <div class="tab-sec">
		<div class="tab">
			<div class="logo">
				<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/dashboard/images/logo.png" alt="" />
			</div>
			<button role="tab" class="tablinks home" onclick="art_gallery_museum_openCity(event, 'tc_index')"><?php esc_html_e( 'Free Theme Information', 'art-gallery-museum' ); ?></button>
		  	<button role="tab" class="tablinks" onclick="art_gallery_museum_openCity(event, 'tc_pro')"><?php esc_html_e( 'Premium Theme Information', 'art-gallery-museum' ); ?></button>
		  	<button role="tab" class="tablinks" onclick="art_gallery_museum_openCity(event, 'tc_create')"><?php esc_html_e( 'Theme Support', 'art-gallery-museum' ); ?></button>				
		</div>

		<div  id="tc_index" class="tabcontent">
			<h2><?php esc_html_e( 'Welcome to Art Gallery Museum Theme', 'art-gallery-museum' ); ?> <span class="version">Version: <?php echo esc_html($theme['Version']);?></span></h2>
			<hr>
			<div class="info-link">
				<a href="<?php echo esc_url( ART_GALLERY_MUSEUM_FREE_THEME_DOC ); ?>" target="_blank"> <?php esc_html_e( 'Documentation', 'art-gallery-museum' ); ?></a>
				<a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e('Customizing', 'art-gallery-museum'); ?></a>
				<a class="get-pro" href="<?php echo esc_url( ART_GALLERY_MUSEUM_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Get Pro', 'art-gallery-museum'); ?></a>
			</div>
			<div class="col-tc-6">
				<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/dashboard/images/screenshot.png" alt="" />
			</div>
			<div class="col-tc-6">
				<P><?php esc_html_e( 'Art Gallery Museum is an attractive WordPress theme built for art galleries, art studios, statue and painting exhibitions, history and monumental libraries, museums, archaeological galleries, etc. This theme comes with a clean, attractive, and sophisticated display giving a beautiful layout for bringing the retina-ready pictures of the museum and art galleries online. It is created using the powerful Bootstrap framework and makes use of standard coding practices. Its mobile-friendly design is going to make your website get a stunning look on several devices and make it available for easy access through smartphones and tablets. Personalization options are made available in case you want to add a few twists to the existing design. This free theme is also made interactive to engage visitors and Call to Action Buttons (CTA) are also included that get reflected in better conversion rates. The codes are optimized and made SEO-friendly for delivering faster page load time and stunning performance across all the browsers and devices. The cleanly designed Team, Testimonial section, and other various theme elements give a positive impact at the first look itself. CSS animations are also added to bring more visual appeal. Social media options for better online promotion are added to the theme.
               ', 'art-gallery-museum' ); ?></P>
			</div>
    	</div>

		<div id="tc_pro" class="tabcontent">
			<h3><?php esc_html_e( 'Art Gallery Museum Theme Information', 'art-gallery-museum' ); ?></h3>
			<hr>
			<div class="pro-image">
				<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/dashboard/images/resize.png" alt="" />
			</div>
			<div class="info-link-pro">
				<p><a href="<?php echo esc_url( ART_GALLERY_MUSEUM_BUY_NOW ); ?>" target="_blank"> <?php esc_html_e( 'Buy Now', 'art-gallery-museum' ); ?></a></p>
				<p><a href="<?php echo esc_url( ART_GALLERY_MUSEUM_LIVE_DEMO ); ?>" target="_blank"> <?php esc_html_e( 'Live Demo', 'art-gallery-museum' ); ?></a></p>
				<p><a href="<?php echo esc_url( ART_GALLERY_MUSEUM_PRO_DOC ); ?>" target="_blank"> <?php esc_html_e( 'Pro Documentation', 'art-gallery-museum' ); ?></a></p>
			</div>
			<div class="col-pro-5">
				<h4><?php esc_html_e( 'Art Gallery Museum Pro Theme', 'art-gallery-museum' ); ?></h4>
				<P><?php esc_html_e( 'If you want a design that has some historic and artistic feel for your archeological work, museums, and exhibition centers, then getting this Museum WordPress Theme will be the right choice for you. Its layout is going to give a perfect website where you will be able to show the amazing art collection, the various artifacts and historical things available for public display in your museum, and more. Coming to the visual appeal, this theme impresses you with its beautiful full-width slider giving a clear idea of what your website is about. Moreover, you will also be very comfortable while working with the theme interface as this Museum WordPress Theme brings a user-friendly design that you can easily use even if you have no experience in web designing or coding. If you think you have got no time, start using the theme’s demo and you will be online within minutes. Various page templates are also made available for you to try and decide what looks the best for your website. For your website to get more subscribers, you have a newsletter that also acts as a lead generation form. This Museum WordPress Theme also gives you plenty of shortcodes and advanced tools to help you create an exceptional website.', 'art-gallery-museum' ); ?></P>		
			</div>
			<div class="col-pro-6">				
				<h4><?php esc_html_e( 'Theme Features', 'art-gallery-museum' ); ?></h4>
				<ul>
					<li><?php esc_html_e( 'Theme Options using Customizer API', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Responsive design', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Favicon, Logo, title and tagline customization', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Advanced Color options', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( '100+ Font Family Options', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Background Image Option', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Simple Menu Option', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Additional section for products', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Enable-Disable options on All sections', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Home Page setting for different sections', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Advance Slider with unlimited slides', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Partner Section', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Promotional Banner Section for Products', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Seperate Newsletter Section', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Text and call to action button for each slides', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Pagination option', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Custom CSS option', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Translations Ready', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Custom Backgrounds, Colors, Headers, Logo & Menu', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Customizable Home Page', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Full-Width Template', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Footer Widgets & Editor Style', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Banner & Post Type Plugin Functionality', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Woo Commerce Compatible', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Multiple Inner Page Templates', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Product Sliders', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Testimonial Slider', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Testimonial Posttype', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Testimonial Listing With Shortcode', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Contact page template', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Contact Widget', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Advance Social Media Feature', 'art-gallery-museum' ); ?></li>
					<li><?php esc_html_e( 'Testimonial Listing With Shortcode0', 'art-gallery-museum' ); ?></li>
				</ul>				
			</div>
		</div>	

		<div id="tc_create" class="tabcontent">
			<h3><?php esc_html_e( 'Support', 'art-gallery-museum' ); ?></h3>
			<hr>
			<div class="tab-cont">
		  		<h4><?php esc_html_e( 'Need Support?', 'art-gallery-museum' ); ?></h4>				
				<div class="info-link-support">
					<P><?php esc_html_e( 'Our team is obliged to help you in every way possible whenever you face any type of difficulties and doubts.', 'art-gallery-museum' ); ?></P>
					<a href="<?php echo esc_url( ART_GALLERY_MUSEUM_SUPPORT ); ?>" target="_blank"> <?php esc_html_e( 'Support Forum', 'art-gallery-museum' ); ?></a>
				</div>
			</div>
			<div class="tab-cont">	
				<h4><?php esc_html_e('Reviews', 'art-gallery-museum'); ?></h4>				
				<div class="info-link-support">
					<P><?php esc_html_e( 'It is commendable to have such a theme inculcated with amazing features and robust functionalities. I feel grateful to recommend this theme to one and all.', 'art-gallery-museum' ); ?></P>
					<a href="<?php echo esc_url( ART_GALLERY_MUSEUM_REVIEW ); ?>" target="_blank"><?php esc_html_e('Reviews', 'art-gallery-museum'); ?></a>
				</div>
			</div>
		</div>
	</div>
</div>
<?php } ?>