<?php
/**
 * Art Gallery Museum Theme Customizer
 *
 * @package Art Gallery Museum
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function art_gallery_museum_customize_register( $wp_customize ) {

	load_template( trailingslashit( get_template_directory() ) . '/inc/icon-changer.php' );

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';

	$wp_customize->selective_refresh->add_partial(
		'blogname',
		array(
			'selector'        => '.site-title a',
			'render_callback' => 'art_gallery_museum_customize_partial_blogname',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'blogdescription',
		array(
			'selector'        => '.site-description',
			'render_callback' => 'art_gallery_museum_customize_partial_blogdescription',
		)
	);

	//add home page setting pannel
	$wp_customize->add_panel( 'art_gallery_museum_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'Theme Settings', 'art-gallery-museum' ),
	) );

    $art_gallery_museum_font_array= array(
        '' =>'No Fonts',
        'Abril Fatface' => 'Abril Fatface',
        'Acme' =>'Acme', 
        'Anton' => 'Anton', 
        'Architects Daughter' =>'Architects Daughter',
        'Arimo' => 'Arimo', 
        'Arsenal' =>'Arsenal',
        'Arvo' =>'Arvo',
        'Alegreya' =>'Alegreya',
        'Alfa Slab One' =>'Alfa Slab One',
        'Averia Serif Libre' =>'Averia Serif Libre', 
        'Bangers' =>'Bangers', 
        'Boogaloo' =>'Boogaloo', 
        'Bad Script' =>'Bad Script',
        'Bitter' =>'Bitter', 
        'Bree Serif' =>'Bree Serif', 
        'BenchNine' =>'BenchNine',
        'Cabin' =>'Cabin',
        'Cardo' =>'Cardo', 
        'Courgette' =>'Courgette', 
        'Cherry Swash' =>'Cherry Swash',
        'Cormorant Garamond' =>'Cormorant Garamond', 
        'Crimson Text' =>'Crimson Text',
        'Cuprum' =>'Cuprum', 
        'Cookie' =>'Cookie',
        'Chewy' =>'Chewy',
        'Days One' =>'Days One',
        'Dosis' =>'Dosis',
        'Droid Sans' =>'Droid Sans', 
        'Economica' =>'Economica', 
        'Fredoka One' =>'Fredoka One',
        'Fjalla One' =>'Fjalla One',
        'Francois One' =>'Francois One', 
        'Frank Ruhl Libre' => 'Frank Ruhl Libre', 
        'Gloria Hallelujah' =>'Gloria Hallelujah',
        'Great Vibes' =>'Great Vibes', 
        'Handlee' =>'Handlee', 
        'Hammersmith One' =>'Hammersmith One',
        'Inconsolata' =>'Inconsolata',
        'Indie Flower' =>'Indie Flower', 
        'IM Fell English SC' =>'IM Fell English SC',
        'Julius Sans One' =>'Julius Sans One',
        'Josefin Slab' =>'Josefin Slab',
        'Josefin Sans' =>'Josefin Sans',
        'Kanit' =>'Kanit',
        'Lobster' =>'Lobster',
        'Lato' => 'Lato',
        'Lora' =>'Lora', 
        'Libre Baskerville' =>'Libre Baskerville',
        'Lobster Two' => 'Lobster Two',
        'Merriweather' =>'Merriweather',
        'Monda' =>'Monda',
        'Montserrat' =>'Montserrat',
        'Muli' =>'Muli',
        'Marck Script' =>'Marck Script',
        'Noto Serif' =>'Noto Serif',
        'Open Sans' =>'Open Sans',
        'Overpass' => 'Overpass', 
        'Overpass Mono' =>'Overpass Mono',
        'Oxygen' =>'Oxygen',
        'Orbitron' =>'Orbitron',
        'Patua One' =>'Patua One',
        'Pacifico' =>'Pacifico',
        'Padauk' =>'Padauk',
        'Playball' =>'Playball',
        'Playfair Display' =>'Playfair Display',
        'PT Sans' =>'PT Sans',
        'Philosopher' =>'Philosopher',
        'Permanent Marker' =>'Permanent Marker',
        'Poiret One' =>'Poiret One',
        'Quicksand' =>'Quicksand',
        'Quattrocento Sans' =>'Quattrocento Sans',
        'Raleway' =>'Raleway',
        'Rubik' =>'Rubik',
        'Rokkitt' =>'Rokkitt',
        'Russo One' => 'Russo One', 
        'Righteous' =>'Righteous', 
        'Slabo' =>'Slabo', 
        'Source Sans Pro' =>'Source Sans Pro',
        'Shadows Into Light Two' =>'Shadows Into Light Two',
        'Shadows Into Light' =>  'Shadows Into Light',
        'Sacramento' =>'Sacramento',
        'Shrikhand' =>'Shrikhand',
        'Tangerine' => 'Tangerine',
        'Ubuntu' =>'Ubuntu',
        'VT323' =>'VT323',
        'Varela Round' =>'Varela Round',
        'Vampiro One' =>'Vampiro One',
        'Vollkorn' => 'Vollkorn',
        'Volkhov' =>'Volkhov',
        'Kavoon' =>'Kavoon',
        'Yanone Kaffeesatz' =>'Yanone Kaffeesatz'
    );

	//Color / Font Pallete
	$wp_customize->add_section( 'art_gallery_museum_typography', array(
    	'title'      => __( 'Color / Font Pallete', 'art-gallery-museum' ),
		'priority'   => 30,
		'panel' => 'art_gallery_museum_panel_id'
	) );

	// This is Body Color setting
	$wp_customize->add_setting( 'art_gallery_museum_body_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'art_gallery_museum_body_color', array(
		'label' => __('Body Color', 'art-gallery-museum'),
		'section' => 'art_gallery_museum_typography',
		'settings' => 'art_gallery_museum_body_color',
	)));

	//This is Body FontFamily  setting
	$wp_customize->add_setting('art_gallery_museum_body_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	));
	$wp_customize->add_control(
		'art_gallery_museum_body_font_family', array(
		'section'  => 'art_gallery_museum_typography',
		'label'    => __( 'Body Fonts','art-gallery-museum'),
		'type'     => 'select',
		'choices'  => $art_gallery_museum_font_array,
	));

    //This is Body Fontsize setting
	$wp_customize->add_setting('art_gallery_museum_body_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('art_gallery_museum_body_font_size',array(
		'label'	=> __('Body Font Size','art-gallery-museum'),
		'section'	=> 'art_gallery_museum_typography',
		'setting'	=> 'art_gallery_museum_body_font_size',
		'type'	=> 'text'
	));
	
	// This is Paragraph Color picker setting
	$wp_customize->add_setting( 'art_gallery_museum_paragraph_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'art_gallery_museum_paragraph_color', array(
		'label' => __('Paragraph Color', 'art-gallery-museum'),
		'section' => 'art_gallery_museum_typography',
		'settings' => 'art_gallery_museum_paragraph_color',
	)));

	//This is Paragraph FontFamily picker setting
	$wp_customize->add_setting('art_gallery_museum_paragraph_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	));
	$wp_customize->add_control(
	    'art_gallery_museum_paragraph_font_family', array(
	    'section'  => 'art_gallery_museum_typography',
	    'label'    => __( 'Paragraph Fonts','art-gallery-museum'),
	    'type'     => 'select',
	    'choices'  => $art_gallery_museum_font_array,
	));

	$wp_customize->add_setting('art_gallery_museum_paragraph_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('art_gallery_museum_paragraph_font_size',array(
		'label'	=> __('Paragraph Font Size','art-gallery-museum'),
		'section'	=> 'art_gallery_museum_typography',
		'setting'	=> 'art_gallery_museum_paragraph_font_size',
		'type'	=> 'text'
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting( 'art_gallery_museum_atag_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'art_gallery_museum_atag_color', array(
		'label' => __('"a" Tag Color', 'art-gallery-museum'),
		'section' => 'art_gallery_museum_typography',
		'settings' => 'art_gallery_museum_atag_color',
	)));

	//This is "a" Tag FontFamily picker setting
	$wp_customize->add_setting('art_gallery_museum_atag_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	));
	$wp_customize->add_control(
	    'art_gallery_museum_atag_font_family', array(
	    'section'  => 'art_gallery_museum_typography',
	    'label'    => __( '"a" Tag Fonts','art-gallery-museum'),
	    'type'     => 'select',
	    'choices'  => $art_gallery_museum_font_array,
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting( 'art_gallery_museum_li_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'art_gallery_museum_li_color', array(
		'label' => __('"li" Tag Color', 'art-gallery-museum'),
		'section' => 'art_gallery_museum_typography',
		'settings' => 'art_gallery_museum_li_color',
	)));

	//This is "li" Tag FontFamily picker setting
	$wp_customize->add_setting('art_gallery_museum_li_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	));
	$wp_customize->add_control(
	    'art_gallery_museum_li_font_family', array(
	    'section'  => 'art_gallery_museum_typography',
	    'label'    => __( '"li" Tag Fonts','art-gallery-museum'),
	    'type'     => 'select',
	    'choices'  => $art_gallery_museum_font_array,
	));

	// This is H1 Color picker setting
	$wp_customize->add_setting( 'art_gallery_museum_h1_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'art_gallery_museum_h1_color', array(
		'label' => __('h1 Color', 'art-gallery-museum'),
		'section' => 'art_gallery_museum_typography',
		'settings' => 'art_gallery_museum_h1_color',
	)));

	//This is H1 FontFamily picker setting
	$wp_customize->add_setting('art_gallery_museum_h1_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	));
	$wp_customize->add_control(
	    'art_gallery_museum_h1_font_family', array(
	    'section'  => 'art_gallery_museum_typography',
	    'label'    => __( 'h1 Fonts','art-gallery-museum'),
	    'type'     => 'select',
	    'choices'  => $art_gallery_museum_font_array,
	));

	//This is H1 FontSize setting
	$wp_customize->add_setting('art_gallery_museum_h1_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('art_gallery_museum_h1_font_size',array(
		'label'	=> __('h1 Font Size','art-gallery-museum'),
		'section'	=> 'art_gallery_museum_typography',
		'setting'	=> 'art_gallery_museum_h1_font_size',
		'type'	=> 'text'
	));

	// This is H2 Color picker setting
	$wp_customize->add_setting( 'art_gallery_museum_h2_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'art_gallery_museum_h2_color', array(
		'label' => __('h2 Color', 'art-gallery-museum'),
		'section' => 'art_gallery_museum_typography',
		'settings' => 'art_gallery_museum_h2_color',
	)));

	//This is H2 FontFamily picker setting
	$wp_customize->add_setting('art_gallery_museum_h2_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	));
	$wp_customize->add_control(
	    'art_gallery_museum_h2_font_family', array(
	    'section'  => 'art_gallery_museum_typography',
	    'label'    => __( 'h2 Fonts','art-gallery-museum'),
	    'type'     => 'select',
	    'choices'  => $art_gallery_museum_font_array,
	));

	//This is H2 FontSize setting
	$wp_customize->add_setting('art_gallery_museum_h2_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('art_gallery_museum_h2_font_size',array(
		'label'	=> __('h2 Font Size','art-gallery-museum'),
		'section'	=> 'art_gallery_museum_typography',
		'setting'	=> 'art_gallery_museum_h2_font_size',
		'type'	=> 'text'
	));

	// This is H3 Color picker setting
	$wp_customize->add_setting( 'art_gallery_museum_h3_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'art_gallery_museum_h3_color', array(
		'label' => __('h3 Color', 'art-gallery-museum'),
		'section' => 'art_gallery_museum_typography',
		'settings' => 'art_gallery_museum_h3_color',
	)));

	//This is H3 FontFamily picker setting
	$wp_customize->add_setting('art_gallery_museum_h3_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	));
	$wp_customize->add_control(
	    'art_gallery_museum_h3_font_family', array(
	    'section'  => 'art_gallery_museum_typography',
	    'label'    => __( 'h3 Fonts','art-gallery-museum'),
	    'type'     => 'select',
	    'choices'  => $art_gallery_museum_font_array,
	));

	//This is H3 FontSize setting
	$wp_customize->add_setting('art_gallery_museum_h3_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('art_gallery_museum_h3_font_size',array(
		'label'	=> __('h3 Font Size','art-gallery-museum'),
		'section'	=> 'art_gallery_museum_typography',
		'setting'	=> 'art_gallery_museum_h3_font_size',
		'type'	=> 'text'
	));

	// This is H4 Color picker setting
	$wp_customize->add_setting( 'art_gallery_museum_h4_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'art_gallery_museum_h4_color', array(
		'label' => __('h4 Color', 'art-gallery-museum'),
		'section' => 'art_gallery_museum_typography',
		'settings' => 'art_gallery_museum_h4_color',
	)));

	//This is H4 FontFamily picker setting
	$wp_customize->add_setting('art_gallery_museum_h4_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	));
	$wp_customize->add_control(
	    'art_gallery_museum_h4_font_family', array(
	    'section'  => 'art_gallery_museum_typography',
	    'label'    => __( 'h4 Fonts','art-gallery-museum'),
	    'type'     => 'select',
	    'choices'  => $art_gallery_museum_font_array,
	));

	//This is H4 FontSize setting
	$wp_customize->add_setting('art_gallery_museum_h4_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('art_gallery_museum_h4_font_size',array(
		'label'	=> __('h4 Font Size','art-gallery-museum'),
		'section'	=> 'art_gallery_museum_typography',
		'setting'	=> 'art_gallery_museum_h4_font_size',
		'type'	=> 'text'
	));

	// This is H5 Color picker setting
	$wp_customize->add_setting( 'art_gallery_museum_h5_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'art_gallery_museum_h5_color', array(
		'label' => __('h5 Color', 'art-gallery-museum'),
		'section' => 'art_gallery_museum_typography',
		'settings' => 'art_gallery_museum_h5_color',
	)));

	//This is H5 FontFamily picker setting
	$wp_customize->add_setting('art_gallery_museum_h5_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	));
	$wp_customize->add_control(
	    'art_gallery_museum_h5_font_family', array(
	    'section'  => 'art_gallery_museum_typography',
	    'label'    => __( 'h5 Fonts','art-gallery-museum'),
	    'type'     => 'select',
	    'choices'  => $art_gallery_museum_font_array,
	));

	//This is H5 FontSize setting
	$wp_customize->add_setting('art_gallery_museum_h5_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('art_gallery_museum_h5_font_size',array(
		'label'	=> __('h5 Font Size','art-gallery-museum'),
		'section'	=> 'art_gallery_museum_typography',
		'setting'	=> 'art_gallery_museum_h5_font_size',
		'type'	=> 'text'
	));

	// This is H6 Color picker setting
	$wp_customize->add_setting( 'art_gallery_museum_h6_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'art_gallery_museum_h6_color', array(
		'label' => __('h6 Color', 'art-gallery-museum'),
		'section' => 'art_gallery_museum_typography',
		'settings' => 'art_gallery_museum_h6_color',
	)));

	//This is H6 FontFamily picker setting
	$wp_customize->add_setting('art_gallery_museum_h6_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	));
	$wp_customize->add_control(
	    'art_gallery_museum_h6_font_family', array(
	    'section'  => 'art_gallery_museum_typography',
	    'label'    => __( 'h6 Fonts','art-gallery-museum'),
	    'type'     => 'select',
	    'choices'  => $art_gallery_museum_font_array,
	));

	//This is H6 FontSize setting
	$wp_customize->add_setting('art_gallery_museum_h6_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('art_gallery_museum_h6_font_size',array(
		'label'	=> __('h6 Font Size','art-gallery-museum'),
		'section'	=> 'art_gallery_museum_typography',
		'setting'	=> 'art_gallery_museum_h6_font_size',
		'type'	=> 'text'
	));

	//Layouts
	$wp_customize->add_section( 'art_gallery_museum_left_right', array(
    	'title'      => __( 'Theme Layout Settings', 'art-gallery-museum' ),
		'priority'   => 30,
		'panel' => 'art_gallery_museum_panel_id'
	) );

	$wp_customize->add_setting('art_gallery_museum_width_options',array(
        'default' => 'Full Layout',
        'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	));
	$wp_customize->add_control('art_gallery_museum_width_options',array(
        'type' => 'select',
        'label' => __('Select Site Layout','art-gallery-museum'),
        'section' => 'art_gallery_museum_left_right',
        'choices' => array(
            'Full Layout' => __('Full Layout','art-gallery-museum'),
            'Contained Layout' => __('Contained Layout','art-gallery-museum'),
            'Boxed Layout' => __('Boxed Layout','art-gallery-museum'),
        ),
	) );

	// Add Settings and Controls for Layout
	$wp_customize->add_setting('art_gallery_museum_theme_options',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	) );
	$wp_customize->add_control('art_gallery_museum_theme_options', array(
        'type' => 'radio',
        'label' => __('Sidebar Layout','art-gallery-museum'),
        'section' => 'art_gallery_museum_left_right',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','art-gallery-museum'),
            'Right Sidebar' => __('Right Sidebar','art-gallery-museum'),
            'One Column' => __('One Column','art-gallery-museum'),
            'Grid Layout' => __('Grid Layout','art-gallery-museum')
        ),
    ));

	// Add Settings and Controls for Layout
	$wp_customize->add_setting('art_gallery_museum_single_post_sidebar',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	) );
	$wp_customize->add_control('art_gallery_museum_single_post_sidebar', array(
        'type' => 'radio',
        'label' => __('Single Post Sidebar Layout','art-gallery-museum'),
        'section' => 'art_gallery_museum_left_right',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','art-gallery-museum'),
            'Right Sidebar' => __('Right Sidebar','art-gallery-museum'),
            'One Column' => __('One Column','art-gallery-museum'),
        ),
    ));

    $wp_customize->add_setting( 'art_gallery_museum_single_page_breadcrumb',array(
		'default' => true,
      	'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ) );
    $wp_customize->add_control('art_gallery_museum_single_page_breadcrumb',array(
    	'type' => 'checkbox',
        'label' => __( 'Show / Hide Single Page Breadcrumb','art-gallery-museum' ),
        'section' => 'art_gallery_museum_left_right'
    ));

	//Header
	$wp_customize->add_section('art_gallery_museum_header',array(
		'title'	=> __('Header','art-gallery-museum'),
		'priority'	=> null,
		'panel' => 'art_gallery_museum_panel_id',
	));

	//Sticky Header
	$wp_customize->add_setting( 'art_gallery_museum_sticky_header',array(
      	'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ) );
    $wp_customize->add_control('art_gallery_museum_sticky_header',array(
    	'type' => 'checkbox',
        'label' => __( 'Sticky Header','art-gallery-museum' ),
        'section' => 'art_gallery_museum_header'
    ));

    $wp_customize->add_setting('art_gallery_museum_sticky_header_padding', array(
		'default'=> '',
		'sanitize_callback'	=> 'art_gallery_museum_sanitize_float'
	));
	$wp_customize->add_control('art_gallery_museum_sticky_header_padding', array(
		'label'	=> __('Sticky Header Padding','art-gallery-museum'),
		'input_attrs' => array(
            'step' => 1,
			'min'  => 0,
			'max'  => 50,
        ),
		'section'=> 'art_gallery_museum_header',
		'type'=> 'number',
	));

	$wp_customize->add_setting('art_gallery_museum_topbar_text',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('art_gallery_museum_topbar_text',array(
		'label'	=> __('Add Topbar Text','art-gallery-museum'),
		'section' => 'art_gallery_museum_header',
		'type'	=> 'text'
	));

	$wp_customize->add_setting('art_gallery_museum_topbar_phoneno',array(
		'default'	=> '',
		'sanitize_callback'	=> 'art_gallery_museum_sanitize_phone_number'
	));	
	$wp_customize->add_control('art_gallery_museum_topbar_phoneno',array(
		'label'	=> __('Add Phone Number','art-gallery-museum'),
		'section' => 'art_gallery_museum_header',
		'type'	=> 'text'
	));

	$wp_customize->add_setting('art_gallery_museum_topbar_time',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('art_gallery_museum_topbar_time',array(
		'label'	=> __('Add Time','art-gallery-museum'),
		'section' => 'art_gallery_museum_header',
		'type'	=> 'text'
	));

	$wp_customize->add_setting('art_gallery_museum_topbar_btn_text',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('art_gallery_museum_topbar_btn_text',array(
		'label'	=> __('Add Button Text','art-gallery-museum'),
		'section' => 'art_gallery_museum_header',
		'type'	=> 'text'
	));

	$wp_customize->add_setting('art_gallery_museum_topbar_btn_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('art_gallery_museum_topbar_btn_url',array(
		'label'	=> __('Add Button URL','art-gallery-museum'),
		'section' => 'art_gallery_museum_header',
		'type'	=> 'text'
	));

	$wp_customize->add_setting('art_gallery_museum_navigation_case',array(
        'default' => 'capitalize',
        'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	));
	$wp_customize->add_control('art_gallery_museum_navigation_case',array(
        'type' => 'select',
        'label' => __('Navigation Case','art-gallery-museum'),
        'section' => 'art_gallery_museum_header',
        'choices' => array(
            'uppercase' => __('Uppercase','art-gallery-museum'),
            'capitalize' => __('Capitalize','art-gallery-museum'),
        ),
	) );

	$wp_customize->add_setting( 'art_gallery_museum_nav_font_size', array(
		'default'           => 15,
		'sanitize_callback' => 'art_gallery_museum_sanitize_float',
	) );
	$wp_customize->add_control( 'art_gallery_museum_nav_font_size', array(
		'label' => __( 'Navigation Font Size','art-gallery-museum' ),
		'section'     => 'art_gallery_museum_header',
		'type'        => 'number',
		'input_attrs' => array(
			'step' => 1,
			'min' => 0,
			'max' => 50,
		),
	) );

	$wp_customize->add_setting('art_gallery_museum_font_weight_menu_option',array(
        'default' => '600',
        'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
    ));
    $wp_customize->add_control('art_gallery_museum_font_weight_menu_option',array(
        'type' => 'select',
        'label' => __('Navigation Font Weight','art-gallery-museum'),
        'section' => 'art_gallery_museum_header',
        'choices' => array(
            '100' => __('100','art-gallery-museum'),
            '200' => __('200','art-gallery-museum'),
            '300' => __('300','art-gallery-museum'),
            '400' => __('400','art-gallery-museum'),
            '500' => __('500','art-gallery-museum'),
            '600' => __('600','art-gallery-museum'),
            '700' => __('700','art-gallery-museum'),
            '800' => __('800','art-gallery-museum'),
            '900' => __('900','art-gallery-museum'),
        ),
	) );

	// Preloader
	$wp_customize->add_setting( 'art_gallery_museum_preloader_hide',array(
		'default' => false,
      	'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ) );
    $wp_customize->add_control('art_gallery_museum_preloader_hide',array(
    	'type' => 'checkbox',
        'label' => __( 'Show / Hide Preloader','art-gallery-museum' ),
        'section' => 'art_gallery_museum_header'
    ));

    $wp_customize->add_setting('art_gallery_museum_preloader_type',array(
        'default'   => 'center-square',
        'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	));
	$wp_customize->add_control( 'art_gallery_museum_preloader_type', array(
		'label' => __( 'Preloader Type','art-gallery-museum' ),
		'section' => 'art_gallery_museum_header',
		'type'  => 'select',
		'settings' => 'art_gallery_museum_preloader_type',
		'choices' => array(
		    'center-square' => __('Center Square','art-gallery-museum'),
		    'chasing-square' => __('Chasing Square','art-gallery-museum'),
	    ),
	));

	$wp_customize->add_setting( 'art_gallery_museum_preloader_color', array(
	    'default' => '#333333',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'art_gallery_museum_preloader_color', array(
  		'label' => 'Preloader Color',
	    'section' => 'art_gallery_museum_header',
	    'settings' => 'art_gallery_museum_preloader_color',
  	)));

  	$wp_customize->add_setting( 'art_gallery_museum_preloader_bg_color', array(
	    'default' => '#fff',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'art_gallery_museum_preloader_bg_color', array(
  		'label' => 'Preloader Background Color',
	    'section' => 'art_gallery_museum_header',
	    'settings' => 'art_gallery_museum_preloader_bg_color',
  	)));

  	$wp_customize->add_setting('art_gallery_museum_menu_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'art_gallery_museum_menu_color', array(
		'label'    => __('Menu Color', 'art-gallery-museum'),
		'section'  => 'art_gallery_museum_header',
		'settings' => 'art_gallery_museum_menu_color',
	)));

	$wp_customize->add_setting('art_gallery_museum_menu_hover_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'art_gallery_museum_menu_hover_color', array(
		'label'    => __('Menu Hover Color', 'art-gallery-museum'),
		'section'  => 'art_gallery_museum_header',
		'settings' => 'art_gallery_museum_menu_hover_color',
	)));

	$wp_customize->add_setting('art_gallery_museum_submenu_menu_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'art_gallery_museum_submenu_menu_color', array(
		'label'    => __('Submenu Color', 'art-gallery-museum'),
		'section'  => 'art_gallery_museum_header',
		'settings' => 'art_gallery_museum_submenu_menu_color',
	)));

	//home page slider
	$wp_customize->add_section( 'art_gallery_museum_slidersettings' , array(
    	'title'      => __( 'Slider Settings', 'art-gallery-museum' ),
		'priority'   => null,
		'panel' => 'art_gallery_museum_panel_id'
	) );

	$wp_customize->selective_refresh->add_partial(
		'art_gallery_museum_slider_hide_show',
		array(
			'selector'        => '#slider .inner_carousel h1',
			'render_callback' => 'art_gallery_museum_customize_partial_art_gallery_museum_slider_hide_show',
		)
	);

	$wp_customize->add_setting('art_gallery_museum_slider_hide_show',array(
       'default' => false,
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
	));
	$wp_customize->add_control('art_gallery_museum_slider_hide_show',array(
	   'type' => 'checkbox',
	   'label' => __('Show / Hide slider','art-gallery-museum'),
	   'section' => 'art_gallery_museum_slidersettings',
	));

	for ( $count = 1; $count <= 4; $count++ ) {
		$wp_customize->add_setting( 'art_gallery_museum_slider_page' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'art_gallery_museum_sanitize_dropdown_pages'
		) );
		$wp_customize->add_control( 'art_gallery_museum_slider_page' . $count, array(
			'label'    => __( 'Select Slide Image Page', 'art-gallery-museum' ),
			'section'  => 'art_gallery_museum_slidersettings',
			'type'     => 'dropdown-pages'
		) );
	}

	$wp_customize->add_setting('art_gallery_museum_slider_title',array(
       'default' => 'true',
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
	));
	$wp_customize->add_control('art_gallery_museum_slider_title',array(
	   'type' => 'checkbox',
	   'label' => __('Show / Hide slider Title','art-gallery-museum'),
	   'section' => 'art_gallery_museum_slidersettings',
	));

	$wp_customize->add_setting('art_gallery_museum_slider_content',array(
       'default' => 'true',
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
	));
	$wp_customize->add_control('art_gallery_museum_slider_content',array(
	   'type' => 'checkbox',
	   'label' => __('Show / Hide slider Content','art-gallery-museum'),
	   'section' => 'art_gallery_museum_slidersettings',
	));

	$wp_customize->add_setting('art_gallery_museum_slider_width_options',array(
    	'default' => 'Full Width',
     	'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	));
	$wp_customize->add_control('art_gallery_museum_slider_width_options',array(
		'type' => 'select',
		'label' => __('Slider Width Layout','art-gallery-museum'),
		'description' => __('Here you can change the Slider Width. ','art-gallery-museum'),
		'section' => 'art_gallery_museum_slidersettings',
		'choices' => array(
		   'Full Width' => __('Full Width','art-gallery-museum'),
		   'Container Width' => __('Container Width','art-gallery-museum'),
		),
	) );

	//content layout
	$wp_customize->add_setting('art_gallery_museum_slider_content_alignment',array(
    	'default' => 'Center',
        'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	));
	$wp_customize->add_control('art_gallery_museum_slider_content_alignment',array(
        'type' => 'radio',
        'label' => __('Slider Content Alignment','art-gallery-museum'),
        'section' => 'art_gallery_museum_slidersettings',
        'choices' => array(
            'Center' => __('Center','art-gallery-museum'),
            'Left' => __('Left','art-gallery-museum'),
            'Right' => __('Right','art-gallery-museum'),
        ),
	) );

	//Slider excerpt
	$wp_customize->add_setting( 'art_gallery_museum_slider_excerpt_length', array(
		'default'              => 20,
		'sanitize_callback'    => 'art_gallery_museum_sanitize_float',
	) );
	$wp_customize->add_control( 'art_gallery_museum_slider_excerpt_length', array(
		'label'       => esc_html__( 'Slider Excerpt length','art-gallery-museum' ),
		'section'     => 'art_gallery_museum_slidersettings',
		'type'        => 'number',
		'settings'    => 'art_gallery_museum_slider_excerpt_length',
		'input_attrs' => array(
			'step'             => 2,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting( 'art_gallery_museum_slider_height', array(
		'default'          => '',
		'sanitize_callback'	=> 'art_gallery_museum_sanitize_float'
	) );
	$wp_customize->add_control( 'art_gallery_museum_slider_height', array(
		'label' => esc_html__( 'Slider Height','art-gallery-museum' ),
		'section' => 'art_gallery_museum_slidersettings',
		'type'    => 'number',
		'description' => __('Measurement is in pixel.','art-gallery-museum'),
		'input_attrs' => array(
			'step' => 1,
			'min'  => 500,
			'max'  => 1000,
		),
	) );

	//Venue Section
	$wp_customize->add_section('art_gallery_museum_venues_section',array(
		'title'	=> __('Venues Section','art-gallery-museum'),
		'panel' => 'art_gallery_museum_panel_id',
	));

	$wp_customize->add_setting('art_gallery_museum_section_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('art_gallery_museum_section_title',array(
		'label'	=> esc_html__('Section Title','art-gallery-museum'),
		'section'=> 'art_gallery_museum_venues_section',
		'type'=> 'text'
	));

	$categories = get_categories();
		$cat_posts = array();
			$i = 0;
			$cat_posts[]='Select';
		foreach($categories as $category){
			if($i==0){
			$default = $category->slug;
			$i++;
		}
		$cat_posts[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('art_gallery_museum_venue_category',array(
		'default'	=> 'select',
		'sanitize_callback' => 'art_gallery_museum_sanitize_choices',
	));
	$wp_customize->add_control('art_gallery_museum_venue_category',array(
		'type'    => 'select',
		'choices' => $cat_posts,
		'label' => __('Select Category to display venues','art-gallery-museum'),
		'section' => 'art_gallery_museum_venues_section',
	));

	//Blog Post
	$wp_customize->add_section('art_gallery_museum_blog_post',array(
		'title'	=> __('Post Settings','art-gallery-museum'),
		'panel' => 'art_gallery_museum_panel_id',
	));	

	$wp_customize->add_setting('art_gallery_museum_date_hide',array(
       'default' => true,
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ));
    $wp_customize->add_control('art_gallery_museum_date_hide',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Post Date','art-gallery-museum'),
       'section' => 'art_gallery_museum_blog_post'
    ));

    $wp_customize->add_setting('art_gallery_museum_author_hide',array(
       'default' => true,
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ));
    $wp_customize->add_control('art_gallery_museum_author_hide',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Post Author','art-gallery-museum'),
       'section' => 'art_gallery_museum_blog_post'
    ));

    $wp_customize->add_setting('art_gallery_museum_comment_hide',array(
       'default' => true,
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ));
    $wp_customize->add_control('art_gallery_museum_comment_hide',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Post Comments','art-gallery-museum'),
       'section' => 'art_gallery_museum_blog_post'
    ));

    $wp_customize->add_setting('art_gallery_museum_time_hide',array(
       'default' => false,
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ));
    $wp_customize->add_control('art_gallery_museum_time_hide',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Post Time','art-gallery-museum'),
       'section' => 'art_gallery_museum_blog_post'
    ));

    $wp_customize->add_setting('art_gallery_museum_feature_image_hide',array(
       'default' => true,
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ));
    $wp_customize->add_control('art_gallery_museum_feature_image_hide',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Featured Image','art-gallery-museum'),
       'section' => 'art_gallery_museum_blog_post'
    ));

    $wp_customize->add_setting( 'art_gallery_museum_featured_image_border_radius', array(
		'default' => 0,
		'sanitize_callback'	=> 'art_gallery_museum_sanitize_float'
	) );
	$wp_customize->add_control( 'art_gallery_museum_featured_image_border_radius', array(
		'label' => __( 'Featured image border radius','art-gallery-museum' ),
		'section' => 'art_gallery_museum_blog_post',
		'type'  => 'number',
		'input_attrs' => array(
			'step' => 1,
			'min'  => 0,
			'max'  => 50,
		),
	) );

    $wp_customize->add_setting( 'art_gallery_museum_featured_image_box_shadow', array(
		'default' => 0,
		'sanitize_callback'	=> 'art_gallery_museum_sanitize_float'
	) );
	$wp_customize->add_control( 'art_gallery_museum_featured_image_box_shadow', array(
		'label' => __( 'Featured image box shadow','art-gallery-museum' ),
		'section' => 'art_gallery_museum_blog_post',
		'type'  => 'number',
		'input_attrs' => array(
			'step' => 1,
			'min'  => 0,
			'max'  => 50,
		),
	) );

    $wp_customize->add_setting('art_gallery_museum_post_content',array(
    	'default' => 'Excerpt Content',
        'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	));
	$wp_customize->add_control('art_gallery_museum_post_content',array(
        'type' => 'radio',
        'label' => __('Post Content Type','art-gallery-museum'),
        'section' => 'art_gallery_museum_blog_post',
        'choices' => array(
            'No Content' => __('No Content','art-gallery-museum'),
            'Full Content' => __('Full Content','art-gallery-museum'),
            'Excerpt Content' => __('Excerpt Content','art-gallery-museum'),
        ),
	) );

    $wp_customize->add_setting( 'art_gallery_museum_post_excerpt_length', array(
		'default'              => 20,
		'sanitize_callback'	=> 'art_gallery_museum_sanitize_float'
	) );
	$wp_customize->add_control( 'art_gallery_museum_post_excerpt_length', array(
		'label' => esc_html__( 'Post Excerpt Length','art-gallery-museum' ),
		'section'  => 'art_gallery_museum_blog_post',
		'type'  => 'number',
		'settings' => 'art_gallery_museum_post_excerpt_length',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting( 'art_gallery_museum_button_excerpt_suffix', array(
		'default'   => __('[...]','art-gallery-museum' ),
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'art_gallery_museum_button_excerpt_suffix', array(
		'label'       => esc_html__( 'Excerpt Suffix','art-gallery-museum' ),
		'section'     => 'art_gallery_museum_blog_post',
		'type'        => 'text',
		'settings' => 'art_gallery_museum_button_excerpt_suffix'
	) );

	$wp_customize->add_setting( 'art_gallery_museum_post_button_text', array(
		'default'   => esc_html__('READ MORE','art-gallery-museum' ),
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'art_gallery_museum_post_button_text', array(
		'label' => esc_html__('Post Button Text','art-gallery-museum' ),
		'section'     => 'art_gallery_museum_blog_post',
		'type'        => 'text',
		'settings'    => 'art_gallery_museum_post_button_text'
	) );

	$wp_customize->add_setting('art_gallery_museum_top_button_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'art_gallery_museum_sanitize_float'
	));
	$wp_customize->add_control('art_gallery_museum_top_button_padding',array(
		'label'	=> __('Top Bottom Button Padding','art-gallery-museum'),
		'input_attrs' => array(
            'step' => 1,
			'min'  => 0,
			'max'  => 50,
        ),
		'section'=> 'art_gallery_museum_blog_post',
		'type'=> 'number',
	));

	$wp_customize->add_setting('art_gallery_museum_left_button_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'art_gallery_museum_sanitize_float'
	));
	$wp_customize->add_control('art_gallery_museum_left_button_padding',array(
		'label'	=> __('Left Right Button Padding','art-gallery-museum'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'art_gallery_museum_blog_post',
		'type'=> 'number',
	));

	$wp_customize->add_setting( 'art_gallery_museum_button_border_radius', array(
		'default'=> '0',
		'sanitize_callback'	=> 'art_gallery_museum_sanitize_float'
	) );
	$wp_customize->add_control('art_gallery_museum_button_border_radius', array(
        'label'  => __('Button Border Radius','art-gallery-museum'),
        'type'=> 'number',
        'section'  => 'art_gallery_museum_blog_post',
        'input_attrs' => array(
        	'step' => 1,
            'min' => 0,
            'max' => 50,
        ),
    ));

    $wp_customize->add_setting( 'art_gallery_museum_post_blocks', array(
        'default'			=> 'Without box',
        'sanitize_callback'	=> 'art_gallery_museum_sanitize_choices'
    ));
    $wp_customize->add_control( 'art_gallery_museum_post_blocks', array(
        'section' => 'art_gallery_museum_blog_post',
        'type' => 'select',
        'label' => __( 'Post blocks', 'art-gallery-museum' ),
        'choices' => array(
            'Within box'  => __( 'Within box', 'art-gallery-museum' ),
            'Without box' => __( 'Without box', 'art-gallery-museum' ),
    )));

    $wp_customize->add_setting('art_gallery_museum_navigation_hide',array(
       'default' => true,
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ));
    $wp_customize->add_control('art_gallery_museum_navigation_hide',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Post Navigation','art-gallery-museum'),
       'section' => 'art_gallery_museum_blog_post'
    ));

    $wp_customize->add_setting( 'art_gallery_museum_post_navigation_type', array(
        'default'			=> 'numbers',
        'sanitize_callback'	=> 'art_gallery_museum_sanitize_choices'
    ));
    $wp_customize->add_control( 'art_gallery_museum_post_navigation_type', array(
        'section' => 'art_gallery_museum_blog_post',
        'type' => 'select',
        'label' => __( 'Post Navigation Type', 'art-gallery-museum' ),
        'choices' => array(
            'numbers'  => __( 'Number', 'art-gallery-museum' ),
            'next-prev' => __( 'Next/Prev Button', 'art-gallery-museum' ),
    )));

    $wp_customize->add_setting( 'art_gallery_museum_post_navigation_position', array(
        'default'			=> 'bottom',
        'sanitize_callback'	=> 'art_gallery_museum_sanitize_choices'
    ));
    $wp_customize->add_control( 'art_gallery_museum_post_navigation_position', array(
        'section' => 'art_gallery_museum_blog_post',
        'type' => 'select',
        'label' => __( 'Post Navigation Position', 'art-gallery-museum' ),
        'choices' => array(
            'top'  => __( 'Top', 'art-gallery-museum' ),
            'bottom' => __( 'Bottom', 'art-gallery-museum' ),
            'both' => __( 'Both', 'art-gallery-museum' ),
    )));

    //Single Post Settings
	$wp_customize->add_section('art_gallery_museum_single_post',array(
		'title'	=> __('Single Post Settings','art-gallery-museum'),
		'panel' => 'art_gallery_museum_panel_id',
	));	

	$wp_customize->add_setting('art_gallery_museum_feature_image',array(
       'default' => true,
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ));
    $wp_customize->add_control('art_gallery_museum_feature_image',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Feature Image','art-gallery-museum'),
       'section' => 'art_gallery_museum_single_post'
    ));

     $wp_customize->add_setting( 'art_gallery_museum_single_post_img_border_radius', array(
		'default'=> 0,
		'sanitize_callback'	=> 'art_gallery_museum_sanitize_float',
	) );
	$wp_customize->add_control( 'art_gallery_museum_single_post_img_border_radius', array(
		'label'       => esc_html__( 'Single Post Image Border Radius','art-gallery-museum' ),
		'section'     => 'art_gallery_museum_single_post',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 100,
		),
	) );

	$wp_customize->add_setting( 'art_gallery_museum_single_post_img_box_shadow',array(
		'default' => 0,
		'sanitize_callback'    => 'art_gallery_museum_sanitize_float',
	));
	$wp_customize->add_control('art_gallery_museum_single_post_img_box_shadow',array(
		'label' => esc_html__( 'Single Post Image Shadow','art-gallery-museum' ),
		'section' => 'art_gallery_museum_single_post',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
		'type' => 'number'
	));

	$wp_customize->add_setting('art_gallery_museum_single_post_date',array(
       'default' => 'true',
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ));
    $wp_customize->add_control('art_gallery_museum_single_post_date',array(
       'type' => 'checkbox',
       'label' => __('Show / Hide Single Post Date','art-gallery-museum'),
       'section' => 'art_gallery_museum_single_post'
    ));

    $wp_customize->add_setting('art_gallery_museum_single_post_author',array(
       'default' => 'true',
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ));
    $wp_customize->add_control('art_gallery_museum_single_post_author',array(
       'type' => 'checkbox',
       'label' => __('Show / Hide Single Post Author','art-gallery-museum'),
       'section' => 'art_gallery_museum_single_post'
    ));

    $wp_customize->add_setting('art_gallery_museum_single_post_comment_no',array(
       'default' => 'true',
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ));
    $wp_customize->add_control('art_gallery_museum_single_post_comment_no',array(
       'type' => 'checkbox',
       'label' => __('Show / Hide Single Post Comment Number','art-gallery-museum'),
       'section' => 'art_gallery_museum_single_post'
    ));

    $wp_customize->add_setting('art_gallery_museum_single_post_time',array(
       'default' => 'true',
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ));
    $wp_customize->add_control('art_gallery_museum_single_post_time',array(
       'type' => 'checkbox',
       'label' => __('Show / Hide Single Post Time','art-gallery-museum'),
       'section' => 'art_gallery_museum_single_post'
    ));

    $wp_customize->add_setting('art_gallery_museum_tags',array(
       'default' => true,
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ));
    $wp_customize->add_control('art_gallery_museum_tags',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Tags','art-gallery-museum'),
       'section' => 'art_gallery_museum_single_post'
    ));

    $wp_customize->add_setting('art_gallery_museum_comment',array(
       'default' => true,
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ));
    $wp_customize->add_control('art_gallery_museum_comment',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Comment','art-gallery-museum'),
       'section' => 'art_gallery_museum_single_post'
    ));

    $wp_customize->add_setting('art_gallery_museum_show_hide_single_post_categories',array(
		'default' => true,
		'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
 	));
 	$wp_customize->add_control('art_gallery_museum_show_hide_single_post_categories',array(
		'type' => 'checkbox',
		'label' => __('Single Post Categories','art-gallery-museum'),
		'section' => 'art_gallery_museum_single_post'
	));

	$wp_customize->add_setting( 'art_gallery_museum_single_post_breadcrumb',array(
		'default' => true,
		'transport' => 'refresh',
      	'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ) );
    $wp_customize->add_control('art_gallery_museum_single_post_breadcrumb',array(
    	'type' => 'checkbox',
        'label' => __( 'Show / Hide Single Post Breadcrumb','art-gallery-museum' ),
        'section' => 'art_gallery_museum_single_post'
    ));

    $wp_customize->add_setting( 'art_gallery_museum_comment_width', array(
		'default' => 100,
		'sanitize_callback'	=> 'art_gallery_museum_sanitize_float'
	) );
	$wp_customize->add_control( 'art_gallery_museum_comment_width', array(
		'label' => __( 'Comment Textarea Width', 'art-gallery-museum'),
		'section' => 'art_gallery_museum_single_post',
		'type' => 'number',
		'settings' => 'art_gallery_museum_comment_width',
		'input_attrs' => array(
			'step' => 1,
			'min' => 0,
			'max' => 100,
		),
	) );

    $wp_customize->add_setting('art_gallery_museum_comment_title',array(
       'default' => __('Leave a Reply','art-gallery-museum'),
       'sanitize_callback'	=> 'sanitize_text_field'
    ));
    $wp_customize->add_control('art_gallery_museum_comment_title',array(
       'type' => 'text',
       'label' => __('Comment form Title','art-gallery-museum'),
       'section' => 'art_gallery_museum_single_post'
    ));

    $wp_customize->add_setting('art_gallery_museum_comment_submit_text',array(
       'default' => __('Post Comment','art-gallery-museum'),
       'sanitize_callback'	=> 'sanitize_text_field'
    ));
    $wp_customize->add_control('art_gallery_museum_comment_submit_text',array(
       'type' => 'text',
       'label' => __('Comment Button Text','art-gallery-museum'),
       'section' => 'art_gallery_museum_single_post'
    ));

    $wp_customize->add_setting('art_gallery_museum_nav_links',array(
       'default' => true,
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ));
    $wp_customize->add_control('art_gallery_museum_nav_links',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Nav Links','art-gallery-museum'),
       'section' => 'art_gallery_museum_single_post'
    ));

    $wp_customize->add_setting('art_gallery_museum_prev_text',array(
       'default' => '',
       'sanitize_callback'	=> 'sanitize_text_field'
    ));
    $wp_customize->add_control('art_gallery_museum_prev_text',array(
       'type' => 'text',
       'label' => __('Previous Navigation Text','art-gallery-museum'),
       'section' => 'art_gallery_museum_single_post'
    ));

    $wp_customize->add_setting('art_gallery_museum_next_text',array(
       'default' => '',
       'sanitize_callback'	=> 'sanitize_text_field'
    ));
    $wp_customize->add_control('art_gallery_museum_next_text',array(
       'type' => 'text',
       'label' => __('Next Navigation Text','art-gallery-museum'),
       'section' => 'art_gallery_museum_single_post'
    ));

    $wp_customize->add_setting('art_gallery_museum_related_posts',array(
       'default' => true,
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ));
    $wp_customize->add_control('art_gallery_museum_related_posts',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Related Posts','art-gallery-museum'),
       'section' => 'art_gallery_museum_single_post'
    ));

    $wp_customize->add_setting('art_gallery_museum_related_posts_title',array(
       'default' => '',
       'sanitize_callback'	=> 'sanitize_text_field'
    ));
    $wp_customize->add_control('art_gallery_museum_related_posts_title',array(
       'type' => 'text',
       'label' => __('Related Posts Title','art-gallery-museum'),
       'section' => 'art_gallery_museum_single_post'
    ));

    $wp_customize->add_setting( 'art_gallery_museum_related_post_count', array(
		'default' => 3,
		'sanitize_callback'	=> 'art_gallery_museum_sanitize_float'
	) );
	$wp_customize->add_control( 'art_gallery_museum_related_post_count', array(
		'label' => esc_html__( 'Related Posts Count','art-gallery-museum' ),
		'section' => 'art_gallery_museum_single_post',
		'type' => 'number',
		'settings' => 'art_gallery_museum_related_post_count',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 6,
		),
	) );

    $wp_customize->add_setting( 'art_gallery_museum_post_order', array(
        'default' => 'categories',
        'sanitize_callback'	=> 'art_gallery_museum_sanitize_choices'
    ));
    $wp_customize->add_control( 'art_gallery_museum_post_order', array(
        'section' => 'art_gallery_museum_single_post',
        'type' => 'radio',
        'label' => __( 'Related Posts Order By', 'art-gallery-museum' ),
        'choices' => array(
            'categories' => __('Categories', 'art-gallery-museum'),
            'tags' => __( 'Tags', 'art-gallery-museum' ),
    )));

    //404 page settings
	$wp_customize->add_section('art_gallery_museum_404_page',array(
		'title'	=> __('404 & No Result Page Settings','art-gallery-museum'),
		'priority'	=> null,
		'panel' => 'art_gallery_museum_panel_id',
	));

	$wp_customize->add_setting('art_gallery_museum_404_title',array(
       'default' => '',
       'sanitize_callback'	=> 'sanitize_text_field'
    ));
    $wp_customize->add_control('art_gallery_museum_404_title',array(
       'type' => 'text',
       'label' => __('404 Page Title','art-gallery-museum'),
       'section' => 'art_gallery_museum_404_page'
    ));

    $wp_customize->add_setting('art_gallery_museum_404_text',array(
       'default' => '',
       'sanitize_callback'	=> 'sanitize_text_field'
    ));
    $wp_customize->add_control('art_gallery_museum_404_text',array(
       'type' => 'text',
       'label' => __('404 Page Text','art-gallery-museum'),
       'section' => 'art_gallery_museum_404_page'
    ));

    $wp_customize->add_setting('art_gallery_museum_404_button_text',array(
       'default' => '',
       'sanitize_callback'	=> 'sanitize_text_field'
    ));
    $wp_customize->add_control('art_gallery_museum_404_button_text',array(
       'type' => 'text',
       'label' => __('404 Page Button Text','art-gallery-museum'),
       'section' => 'art_gallery_museum_404_page'
    ));

    $wp_customize->add_setting('art_gallery_museum_no_result_title',array(
       'default' => '',
       'sanitize_callback'	=> 'sanitize_text_field'
    ));
    $wp_customize->add_control('art_gallery_museum_no_result_title',array(
       'type' => 'text',
       'label' => __('No Result Page Title','art-gallery-museum'),
       'section' => 'art_gallery_museum_404_page'
    ));

    $wp_customize->add_setting('art_gallery_museum_no_result_text',array(
       'default' => '',
       'sanitize_callback'	=> 'sanitize_text_field'
    ));
    $wp_customize->add_control('art_gallery_museum_no_result_text',array(
       'type' => 'text',
       'label' => __('No Result Page Text','art-gallery-museum'),
       'section' => 'art_gallery_museum_404_page'
    ));

    $wp_customize->add_setting('art_gallery_museum_show_search_form',array(
        'default' => true,
        'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
	));
	$wp_customize->add_control('art_gallery_museum_show_search_form',array(
     	'type' => 'checkbox',
      	'label' => __('Show/Hide Search Form','art-gallery-museum'),
      	'section' => 'art_gallery_museum_404_page',
	));

	//Footer
	$wp_customize->add_section('art_gallery_museum_footer_section',array(
		'title'	=> __('Footer Section','art-gallery-museum'),
		'priority'	=> null,
		'panel' => 'art_gallery_museum_panel_id',
	));

	$wp_customize->selective_refresh->add_partial(
		'art_gallery_museum_show_back_to_top',
		array(
			'selector'        => '.scrollup',
			'render_callback' => 'art_gallery_museum_customize_partial_art_gallery_museum_show_back_to_top',
		)
	);

	$wp_customize->add_setting('art_gallery_museum_show_back_to_top',array(
        'default' => 'true',
        'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
	));
	$wp_customize->add_control('art_gallery_museum_show_back_to_top',array(
     	'type' => 'checkbox',
      	'label' => __('Show/Hide Back to Top Button','art-gallery-museum'),
      	'section' => 'art_gallery_museum_footer_section',
	));

	$wp_customize->add_setting('art_gallery_museum_back_to_top_icon',array(
		'default'	=> 'fas fa-arrow-up',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Art_Gallery_Museum_Icon_Changer(
        $wp_customize, 'art_gallery_museum_back_to_top_icon',array(
		'label'	=> __('Back to Top Icon','art-gallery-museum'),
		'section'	=> 'art_gallery_museum_footer_section',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('art_gallery_museum_back_to_top_text',array(
		'default'	=> __('Back to Top','art-gallery-museum'),
		'sanitize_callback'	=> 'sanitize_text_field',
	));	
	$wp_customize->add_control('art_gallery_museum_back_to_top_text',array(
		'label'	=> __('Back to Top Button Text','art-gallery-museum'),
		'section'	=> 'art_gallery_museum_footer_section',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('art_gallery_museum_back_to_top_alignment',array(
        'default' => 'Right',
        'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	));
	$wp_customize->add_control('art_gallery_museum_back_to_top_alignment',array(
        'type' => 'select',
        'label' => __('Back to Top Button Alignment','art-gallery-museum'),
        'section' => 'art_gallery_museum_footer_section',
        'choices' => array(
            'Left' => __('Left','art-gallery-museum'),
            'Right' => __('Right','art-gallery-museum'),
            'Center' => __('Center','art-gallery-museum'),
        ),
	) );

	$wp_customize->add_setting('art_gallery_museum_footer_background_color', array(
		'default'           => '#000',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'art_gallery_museum_footer_background_color', array(
		'label'    => __('Footer Background Color', 'art-gallery-museum'),
		'section'  => 'art_gallery_museum_footer_section',
	)));

	$wp_customize->add_setting('art_gallery_museum_footer_background_img',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'art_gallery_museum_footer_background_img',array(
        'label' => __('Footer Background Image','art-gallery-museum'),
        'section' => 'art_gallery_museum_footer_section'
	)));

	$wp_customize->add_setting('art_gallery_museum_footer_widget_layout',array(
        'default'           => '4',
        'sanitize_callback' => 'art_gallery_museum_sanitize_choices',
    ));
    $wp_customize->add_control('art_gallery_museum_footer_widget_layout',array(
        'type' => 'radio',
        'label'  => __('Footer widget layout', 'art-gallery-museum'),
        'section'     => 'art_gallery_museum_footer_section',
        'description' => __('Select the number of widget areas you want in the footer. After that, go to Appearance > Widgets and add your widgets.', 'art-gallery-museum'),
        'choices' => array(
            '1'     => __('One', 'art-gallery-museum'),
            '2'     => __('Two', 'art-gallery-museum'),
            '3'     => __('Three', 'art-gallery-museum'),
            '4'     => __('Four', 'art-gallery-museum')
        ),
    ));

    $wp_customize->add_setting('art_gallery_museum_copyright_alignment',array(
        'default' => 'Center',
        'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	));
	$wp_customize->add_control('art_gallery_museum_copyright_alignment',array(
        'type' => 'select',
        'label' => __('Copyright Alignment','art-gallery-museum'),
        'section' => 'art_gallery_museum_footer_section',
        'choices' => array(
            'Left' => __('Left','art-gallery-museum'),
            'Right' => __('Right','art-gallery-museum'),
            'Center' => __('Center','art-gallery-museum'),
        ),
	) );

	$wp_customize->add_setting('art_gallery_museum_copyright_fontsize',array(
		'default'	=> 16,
		'sanitize_callback'	=> 'art_gallery_museum_sanitize_float',
	));	
	$wp_customize->add_control('art_gallery_museum_copyright_fontsize',array(
		'label'	=> __('Copyright Font Size','art-gallery-museum'),
		'section'	=> 'art_gallery_museum_footer_section',
		'type'		=> 'number'
	));

	$wp_customize->add_setting('art_gallery_museum_copyright_top_bottom_padding',array(
		'default'	=> 15,
		'sanitize_callback'	=> 'art_gallery_museum_sanitize_float',
	));	
	$wp_customize->add_control('art_gallery_museum_copyright_top_bottom_padding',array(
		'label'	=> __('Copyright Top Bottom Padding','art-gallery-museum'),
		'section'	=> 'art_gallery_museum_footer_section',
		'type'		=> 'number'
	));

    $wp_customize->selective_refresh->add_partial(
		'art_gallery_museum_footer_copy',
		array(
			'selector'        => '#footer p',
			'render_callback' => 'art_gallery_museum_customize_partial_art_gallery_museum_footer_copy',
		)
	);
	
	$wp_customize->add_setting('art_gallery_museum_footer_copy',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field',
	));	
	$wp_customize->add_control('art_gallery_museum_footer_copy',array(
		'label'	=> __('Copyright Text','art-gallery-museum'),
		'section'	=> 'art_gallery_museum_footer_section',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('art_gallery_museum_copyright_background_color', array(
		'default'           => '#000',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'art_gallery_museum_copyright_background_color', array(
		'label'    => __('Copyright Background Color', 'art-gallery-museum'),
		'section'  => 'art_gallery_museum_footer_section',
	)));

	//Mobile Media Section
	$wp_customize->add_section( 'art_gallery_museum_mobile_media_options' , array(
    	'title'      => __( 'Mobile Media Options', 'art-gallery-museum' ),
		'priority'   => null,
		'panel' => 'art_gallery_museum_panel_id'
	) );

	$wp_customize->add_setting('art_gallery_museum_responsive_open_menu_icon',array(
		'default'	=> 'fas fa-bars',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Art_Gallery_Museum_Icon_Changer(
        $wp_customize, 'art_gallery_museum_responsive_open_menu_icon',array(
		'label'	=> __('Open Menu Icon','art-gallery-museum'),
		'section'	=> 'art_gallery_museum_mobile_media_options',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting( 'art_gallery_museum_menu_color_setting', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'art_gallery_museum_menu_color_setting', array(
  		'label' => __('Menu Icon Color Option', 'art-gallery-museum'),
		'section' => 'art_gallery_museum_mobile_media_options',
		'settings' => 'art_gallery_museum_menu_color_setting',
  	)));

	$wp_customize->add_setting('art_gallery_museum_responsive_close_menu_icon',array(
		'default'	=> 'fas fa-times',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Art_Gallery_Museum_Icon_Changer(
        $wp_customize, 'art_gallery_museum_responsive_close_menu_icon',array(
		'label'	=> __('Close Menu Icon','art-gallery-museum'),
		'section'	=> 'art_gallery_museum_mobile_media_options',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting('art_gallery_museum_responsive_show_back_to_top',array(
        'default' => true,
        'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
	));
	$wp_customize->add_control('art_gallery_museum_responsive_show_back_to_top',array(
     	'type' => 'checkbox',
      	'label' => __('Show / Hide Back to Top Button','art-gallery-museum'),
      	'section' => 'art_gallery_museum_mobile_media_options',
	));

	$wp_customize->add_setting( 'art_gallery_museum_responsive_preloader_hide',array(
		'default' => false,
      	'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ) );
    $wp_customize->add_control('art_gallery_museum_responsive_preloader_hide',array(
    	'type' => 'checkbox',
        'label' => __( 'Show / Hide Preloader','art-gallery-museum' ),
        'section' => 'art_gallery_museum_mobile_media_options'
    ));

	//Woocommerce Section
	$wp_customize->add_section( 'art_gallery_museum_woocommerce_options' , array(
    	'title'      => __( 'Additional WooCommerce Options', 'art-gallery-museum' ),
		'priority'   => null,
		'panel' => 'art_gallery_museum_panel_id'
	) );

	// Product Columns
	$wp_customize->add_setting( 'art_gallery_museum_products_per_row' , array(
		'default'           => '3',
		'sanitize_callback' => 'art_gallery_museum_sanitize_choices',
	) );

	$wp_customize->add_control('art_gallery_museum_products_per_row', array(
		'label' => __( 'Product per row', 'art-gallery-museum' ),
		'section'  => 'art_gallery_museum_woocommerce_options',
		'type'     => 'select',
		'choices'  => array(
			'2' => '2',
			'3' => '3',
			'4' => '4',
		),
	) );

	$wp_customize->add_setting('art_gallery_museum_product_per_page',array(
		'default'	=> '9',
		'sanitize_callback'	=> 'art_gallery_museum_sanitize_float'
	));	
	$wp_customize->add_control('art_gallery_museum_product_per_page',array(
		'label'	=> __('Product per page','art-gallery-museum'),
		'section'	=> 'art_gallery_museum_woocommerce_options',
		'type'		=> 'number'
	));

	$wp_customize->add_setting('art_gallery_museum_shop_sidebar',array(
       'default' => true,
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ));
    $wp_customize->add_control('art_gallery_museum_shop_sidebar',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Shop page sidebar','art-gallery-museum'),
       'section' => 'art_gallery_museum_woocommerce_options',
    ));

    // shop page sidebar alignment
    $wp_customize->add_setting('art_gallery_museum_shop_page_layout', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'art_gallery_museum_sanitize_choices',
	));
	$wp_customize->add_control('art_gallery_museum_shop_page_layout',array(
		'type'           => 'radio',
		'label'          => __('Shop Page layout', 'art-gallery-museum'),
		'section'        => 'art_gallery_museum_woocommerce_options',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'art-gallery-museum'),
			'Right Sidebar' => __('Right Sidebar', 'art-gallery-museum'),
		),
	));

	$wp_customize->add_setting( 'art_gallery_museum_wocommerce_single_page_sidebar',array(
		'default' => true,
		'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ) );
    $wp_customize->add_control('art_gallery_museum_wocommerce_single_page_sidebar',array(
    	'type' => 'checkbox',
       	'label' => __('Enable / Disable Single Product Page Sidebar','art-gallery-museum'),
		'section' => 'art_gallery_museum_woocommerce_options'
    ));

    // single product page sidebar alignment
    $wp_customize->add_setting('art_gallery_museum_single_product_page_layout', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'art_gallery_museum_sanitize_choices',
	));
	$wp_customize->add_control('art_gallery_museum_single_product_page_layout',array(
		'type'           => 'radio',
		'label'          => __('Single product Page layout', 'art-gallery-museum'),
		'section'        => 'art_gallery_museum_woocommerce_options',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'art-gallery-museum'),
			'Right Sidebar' => __('Right Sidebar', 'art-gallery-museum'),
		),
	));

	$wp_customize->add_setting('art_gallery_museum_shop_page_pagination',array(
       'default' => true,
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ));
    $wp_customize->add_control('art_gallery_museum_shop_page_pagination',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Shop page pagination','art-gallery-museum'),
       'section' => 'art_gallery_museum_woocommerce_options',
    ));

    $wp_customize->add_setting('art_gallery_museum_product_page_sidebar',array(
       'default' => true,
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ));
    $wp_customize->add_control('art_gallery_museum_product_page_sidebar',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Product page sidebar','art-gallery-museum'),
       'section' => 'art_gallery_museum_woocommerce_options',
    ));

    $wp_customize->add_setting('art_gallery_museum_related_product',array(
       'default' => true,
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ));
    $wp_customize->add_control('art_gallery_museum_related_product',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Related product','art-gallery-museum'),
       'section' => 'art_gallery_museum_woocommerce_options',
    ));

	$wp_customize->add_setting( 'art_gallery_museum_woocommerce_button_padding_top',array(
		'default' => 10,
		'sanitize_callback' => 'art_gallery_museum_sanitize_float'
	));
	$wp_customize->add_control( 'art_gallery_museum_woocommerce_button_padding_top',	array(
		'label' => esc_html__( 'Button Top Bottom Padding','art-gallery-museum' ),
		'type' => 'number',
		'section' => 'art_gallery_museum_woocommerce_options',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	));

	$wp_customize->add_setting( 'art_gallery_museum_woocommerce_button_padding_right',array(
	 	'default' => 20,
	 	'sanitize_callback' => 'art_gallery_museum_sanitize_float'
	));
	$wp_customize->add_control('art_gallery_museum_woocommerce_button_padding_right',	array(
	 	'label' => esc_html__( 'Button Right Left Padding','art-gallery-museum' ),
		'type' => 'number',
		'section' => 'art_gallery_museum_woocommerce_options',
	 	'input_attrs' => array(
			'min' => 0,
			'max' => 50,
	 		'step' => 1,
		),
	));

	$wp_customize->add_setting( 'art_gallery_museum_woocommerce_button_border_radius',array(
		'default' => 0,
		'sanitize_callback' => 'art_gallery_museum_sanitize_float'
	));
	$wp_customize->add_control('art_gallery_museum_woocommerce_button_border_radius',array(
		'label' => esc_html__( 'Button Border Radius','art-gallery-museum' ),
		'type' => 'number',
		'section' => 'art_gallery_museum_woocommerce_options',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	));

    $wp_customize->add_setting('art_gallery_museum_woocommerce_product_border',array(
       'default' => true,
       'sanitize_callback'	=> 'art_gallery_museum_sanitize_checkbox'
    ));
    $wp_customize->add_control('art_gallery_museum_woocommerce_product_border',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable product border','art-gallery-museum'),
       'section' => 'art_gallery_museum_woocommerce_options',
    ));

	$wp_customize->add_setting( 'art_gallery_museum_woocommerce_product_padding_top',array(
		'default' => 10,
		'sanitize_callback' => 'art_gallery_museum_sanitize_float'
	));
	$wp_customize->add_control('art_gallery_museum_woocommerce_product_padding_top', array(
		'label' => esc_html__( 'Product Top Bottom Padding','art-gallery-museum' ),
		'type' => 'number',
		'section' => 'art_gallery_museum_woocommerce_options',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	));

	$wp_customize->add_setting( 'art_gallery_museum_woocommerce_product_padding_right',array(
		'default' => 10,
		'sanitize_callback' => 'art_gallery_museum_sanitize_float'
	));
	$wp_customize->add_control('art_gallery_museum_woocommerce_product_padding_right', array(
		'label' => esc_html__( 'Product Right Left Padding','art-gallery-museum' ),
		'type' => 'number',
		'section' => 'art_gallery_museum_woocommerce_options',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	));

	$wp_customize->add_setting( 'art_gallery_museum_woocommerce_product_border_radius',array(
		'default' => 0,
		'sanitize_callback' => 'art_gallery_museum_sanitize_float'
	));
	$wp_customize->add_control('art_gallery_museum_woocommerce_product_border_radius',array(
		'label' => esc_html__( 'Product Border Radius','art-gallery-museum' ),
		'type' => 'number',
		'section' => 'art_gallery_museum_woocommerce_options',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	));

	$wp_customize->add_setting( 'art_gallery_museum_woocommerce_product_box_shadow',array(
		'default' => 0,
		'sanitize_callback' => 'art_gallery_museum_sanitize_float'
	));
	$wp_customize->add_control( 'art_gallery_museum_woocommerce_product_box_shadow',array(
		'label' => esc_html__( 'Product Box Shadow','art-gallery-museum' ),
		'type' => 'number',
		'section' => 'art_gallery_museum_woocommerce_options',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	));

	$wp_customize->add_setting('art_gallery_museum_sale_position',array(
        'default' => 'right',
        'sanitize_callback' => 'art_gallery_museum_sanitize_choices'
	));
	$wp_customize->add_control('art_gallery_museum_sale_position',array(
        'type' => 'select',
        'label' => __('Sale badge Position','art-gallery-museum'),
        'section' => 'art_gallery_museum_woocommerce_options',
        'choices' => array(
            'left' => __('Left','art-gallery-museum'),
            'right' => __('Right','art-gallery-museum'),
        ),
	) );

	$wp_customize->add_setting( 'art_gallery_museum_woocommerce_sale_top_padding',array(
		'default' => 0,
		'sanitize_callback' => 'art_gallery_museum_sanitize_float'
	));
	$wp_customize->add_control( 'art_gallery_museum_woocommerce_sale_top_padding',	array(
		'label' => esc_html__( 'Sale Top Bottom Padding','art-gallery-museum' ),
		'type' => 'number',
		'section' => 'art_gallery_museum_woocommerce_options',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	));

	$wp_customize->add_setting( 'art_gallery_museum_woocommerce_sale_left_padding',array(
	 	'default' => 0,
	 	'sanitize_callback' => 'art_gallery_museum_sanitize_float'
	));
	$wp_customize->add_control('art_gallery_museum_woocommerce_sale_left_padding',	array(
	 	'label' => esc_html__( 'Sale Right Left Padding','art-gallery-museum' ),
		'type' => 'number',
		'section' => 'art_gallery_museum_woocommerce_options',
	 	'input_attrs' => array(
			'min' => 0,
			'max' => 50,
	 		'step' => 1,
		),
	));

	$wp_customize->add_setting( 'art_gallery_museum_woocommerce_sale_border_radius',array(
		'default' => 0,
		'sanitize_callback' => 'art_gallery_museum_sanitize_float'
	));
	$wp_customize->add_control('art_gallery_museum_woocommerce_sale_border_radius',array(
		'label' => esc_html__( 'Sale Border Radius','art-gallery-museum' ),
		'type' => 'number',
		'section' => 'art_gallery_museum_woocommerce_options',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	));

	$wp_customize->add_setting( 'art_gallery_museum_product_sale_font_size',array(
		'default' => '',
		'sanitize_callback' => 'art_gallery_museum_sanitize_float'
	));
	$wp_customize->add_control('art_gallery_museum_product_sale_font_size',array(
		'label' => esc_html__( 'Sale Font Size','art-gallery-museum' ),
		'type' => 'number',
		'section' => 'art_gallery_museum_woocommerce_options',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	));
}
add_action( 'customize_register', 'art_gallery_museum_customize_register' );

// logo resize
load_template( trailingslashit( get_template_directory() ) . '/inc/logo/logo-width.php' );


/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class art_gallery_museum_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );
		
		// Register custom section types.
		$manager->register_section_type( 'Art_Gallery_Museum_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Art_Gallery_Museum_Customize_Section_Pro(
				$manager,
				'art_gallery_museum_example_1',
				array(
					'priority' => 9,
					'title'    => esc_html__( 'Museum Pro Theme', 'art-gallery-museum' ),
					'pro_text' => esc_html__( 'Go Pro','art-gallery-museum' ),
					'pro_url'  => esc_url( 'https://www.themescaliber.com/themes/museum-wordpress-theme/' ),
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'art-gallery-museum-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'art-gallery-museum-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
art_gallery_museum_Customize::get_instance();