<?php
/**
 * @package Art Gallery Museum
 * @subpackage art-gallery-museum
 * @since art-gallery-museum 1.0
 * Setup the WordPress core custom header feature.
 *
 * @uses art_gallery_museum_header_style()
*/

function art_gallery_museum_custom_header_setup() {

	add_theme_support( 'custom-header', apply_filters( 'art_gallery_museum_custom_header_args', array(
		'default-text-color' => 'fff',
		'header-text' 	     =>	false,
		'width'              => 1400,
		'height'             => 80,
		'flex-height'        => true,
	    'flex-width'         => true,
		'wp-head-callback'   => 'art_gallery_museum_header_style',
	) ) );

}

add_action( 'after_setup_theme', 'art_gallery_museum_custom_header_setup' );

if ( ! function_exists( 'art_gallery_museum_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog
 *
 * @see art_gallery_museum_custom_header_setup().
 */
add_action( 'wp_enqueue_scripts', 'art_gallery_museum_header_style' );
function art_gallery_museum_header_style() {
	//Check if user has defined any header image.
	if ( get_header_image() ) :
	$art_gallery_museum_custom_css = "
        .menu-section, .page-template-custom-frontpage .menu-section{
			background-image:url('".esc_url(get_header_image())."');
			background-position: center top;
			background-size: 100% 100%;
		}
		";
	   	wp_add_inline_style( 'art-gallery-museum-basic-style', $art_gallery_museum_custom_css );
	endif;
}
endif; // art_gallery_museum_header_style
